using Microsoft.Win32;
using System;
using System.Collections;
using System.IO;
using System.Net;
using System.Reflection;

public class Csutil {

  // avgtmp - get average temperature for a period

  // downloads data using an API at visualcrossing.com
  // requires an account key for the site

  // 12/28/23 new program
  // 02/07/24 fixed command line argument processing
  // 02/08/26 forced TLS 1.2/1.3

  static int Main(string[] ppqargs) {

    bool lerr = false;
    string pqarg;
    string pqzip = null;
    RegistryKey RKhkcu;
    RegistryKey RKsoftware;
    RegistryKey RKexeye;
    RegistryKey RKavgtmp;
    DateTime DTexe;
    DateTime DTbeg = new DateTime();
    DateTime DTend = new DateTime();

    // get our default printer from the registry if present
    RKhkcu = Registry.CurrentUser;
    RKsoftware = RKhkcu.CreateSubKey("Software");
    RKexeye = RKsoftware.CreateSubKey("EXEYE");
    RKavgtmp = RKexeye.CreateSubKey("AVGTMP");
    string pqkey = (string)RKavgtmp.GetValue("APIkey");

    Console.WriteLine();

    // check that there is an API key
    if (pqkey == null || pqkey == "") {
      Console.WriteLine("*** No API Key set!");
      Console.WriteLine("    Data is obtained from www.visualcrossing.com.");
      Console.WriteLine("    You must go there, create an account, "+
                        "select a plan,");
      Console.WriteLine("    get an API Key, and enter it into this program, "+
                        "using this command:");
      Console.WriteLine();
      Console.WriteLine("    avgtmp -K mykey");
      Console.WriteLine();
      Console.WriteLine();
      lerr = true;
    }

    // error if not enough arguments
    if (ppqargs.Length < 2) lerr = true;

    // process argument list
    for (int narg = 0; narg < ppqargs.Length; narg++) {

      // process parameters
      pqarg = ppqargs[narg];
      if (pqarg.Length > 0 && pqarg[0] == '-') {
        pqarg = pqarg.ToUpper();

        // API key parameter
        if (pqarg.Length == 2 && pqarg[1] == 'K') {
          if (ppqargs.Length == 2) {
            narg++;
            RKavgtmp.SetValue("APIkey",ppqargs[narg]);
            Console.WriteLine("Setting API Key in registry:");
            Console.WriteLine("HKCU\\Software\\EXEYE\\AVGTMP\\APIkey "+
              "set to: "+ppqargs[narg]);
            return 0;
          }
        }

        else {
          Console.WriteLine("parameter '"+pqarg+"' not recognized");
          Console.WriteLine();
          lerr = true;
        }
      }

      // process arguments
      if (!lerr && narg == 0 && ppqargs.Length == 3) {
        pqzip = ppqargs[narg++];
        if (pqzip.Length != 5) {
          Console.WriteLine("invalid zip code parameter: "+pqzip);
          Console.WriteLine();
          lerr = true;
        }
        foreach (char qar in pqzip) if (qar < '0' || qar > '9') lerr = true;
        try {
          DTbeg = DateTime.Parse(ppqargs[narg++]);
          DTend = DateTime.Parse(ppqargs[narg]);
        }
        catch (Exception E) {
          Console.WriteLine("invalid date parameter: "+E);
          Console.WriteLine();
          lerr = true;
        }
      }
      else lerr = true;
    }

    // print instructions if too few parameters
    if (lerr) {
      DTexe = File.GetLastWriteTime(
                               Assembly.GetExecutingAssembly().Location);
      Console.Write("AVGTMP - look up average temperature for "+
                    "a date range - ");
      Console.WriteLine(DTexe.ToString("d"));
      Console.WriteLine();
      Console.WriteLine("To execute enter: AVGTMP zip start end");
      Console.WriteLine();
      Console.WriteLine("  zip is five-digit zip code of desired location");
      Console.WriteLine("  start is start date");
      Console.WriteLine("  end is end date");
      return 1;
    }

/*     // report parsed input parameters */
/*     Console.WriteLine("zip="+pqzip+"  begin="+DTbeg.ToString("d")+"  end="+ */
/*                       DTend.ToString("d")); */
/*     Console.WriteLine(); */

    // build URL  to get results from visualcrossing.com
    string pqurl = "https://weather.visualcrossing.com/"+
                   "VisualCrossingWebServices/rest/services/timeline/";
    pqurl += pqzip;
    pqurl += "/";
    pqurl += DTbeg.ToString("yyyy'-'MM'-'dd");
    pqurl += "/";
    pqurl += DTend.ToString("yyyy'-'MM'-'dd");
    pqurl += "?unitGroup=us&elements=datetime%2Ctempmax%2Ctempmin&"+
             "include=days%2Cobs%2Cremote&"+
             "key=VMJHNSCZW8RDEJ8BBA9NJ6WAL&contentType=json";
/*     Console.WriteLine("URL is:"); */
/*     Console.WriteLine(pqurl); */

    // get results from visualcrossing.com
    string pqjson = "";
    try {
      ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12 |
                                             SecurityProtocolType.Tls13;
      WebClient WC = new WebClient();
      WC.Headers.Add("user-agent","Mozilla/4.0 (compatible; MSIE 6.0; "+
                                  "Windows NT 5.2;.NET CLR 1.0.3705;)");
      Stream Surl = WC.OpenRead(pqurl);
      StreamReader SR = new StreamReader(Surl);
      pqjson = SR.ReadToEnd();
    }
    catch (Exception E) {
      Console.WriteLine("*** data request failed");
      Console.WriteLine();
      Console.WriteLine(E);
      Console.WriteLine();
      return 2;
    }
/*     Console.WriteLine("returned result is:"); */
/*     Console.WriteLine(pqjson); */

    // sample returned json data:
    // {"queryCost":5,"latitude":41.196044,"longitude":-73.96836,
    // "resolvedAddress":"10927, USA","address":"10927",
    // "timezone":"America/New_York","tzoffset":-5.0,
    // "days":[
    // {"datetime":"2023-12-03","tempmax":47.9,"tempmin":44.0},
    // {"datetime":"2023-12-04","tempmax":49.9,"tempmin":38.7},
    // {"datetime":"2023-12-05","tempmax":41.4,"tempmin":35.0},
    // {"datetime":"2023-12-06","tempmax":39.7,"tempmin":30.7},
    // {"datetime":"2023-12-07","tempmax":35.8,"tempmin":29.9}]}

    // get each day's average temperature and compute the overall average
    if (pqjson.Contains("\"days\":[")) {
      int ncolmax = 0;
      int ncolmin = 0;
      string pqmax = "\"tempmax\":";
      string pqmin = "\"tempmin\":";
      int nvals = 0;
      double dmaxtot = 0;
      double dmintot = 0;
      for (;;) {
        ncolmax = pqjson.IndexOf(pqmax,ncolmax);
        ncolmin = pqjson.IndexOf(pqmin,ncolmin);
        if (ncolmax < 0) break;
        ncolmax += pqmax.Length;
        ncolmin += pqmin.Length;
        string pqvalmax = pqjson.Substring(ncolmax);
        string pqvalmin = pqjson.Substring(ncolmin);
        pqvalmax = pqvalmax.Substring(0,pqvalmax.IndexOf(','));
        pqvalmin = pqvalmin.Substring(0,pqvalmin.IndexOf('}'));
        double dmax = Double.Parse(pqvalmax);
        double dmin = Double.Parse(pqvalmin);
        nvals++;
        dmaxtot += dmax;
        dmintot += dmin;
      }
/*       Console.WriteLine("average maximum temperature: "+(dmaxtot/nvals)+ */
/*                         " average minimum temperature: "+(dmintot/nvals)); */
      double davgtmp = ((dmaxtot+dmintot)/2)/nvals;
      Console.WriteLine("from "+DTbeg.ToString("d")+
                        " through "+DTend.ToString("d")+" ("+nvals+" days)"+
                        " average temperature is "+davgtmp.ToString("F2"));
    }
    else {
      Console.WriteLine("*** error: unexpected return string");
      Console.WriteLine(pqjson);
      Console.WriteLine();
      return 2;
    }

    return 0;
  }
}
